/************************************
シリアルポートの設定
************************************/

#include "main.h"
#include "sci.h"
//#include "serial.h"
#include "MODSERIAL.h"

unsigned short inCount3;
unsigned short outCount3;
unsigned short usBufCount3;
char rBuffer3[500];
char cBuffer3[500];

void fngetchar3(MODSERIAL_IRQ_INFO *q);

//シリアルポートの初期化（初期化は関数内で行えるが、他の関数で使えなくなる。
//Serial serial_port3(p28,p27);
MODSERIAL serial_port3(p28,p27);
//Serial serial_port3(USBTX,USBRX);


/************************************
関数名
    fnsci3Init
引数
    シリアルポートのビットレート
説明
    シリアルポートの設定を行う。
    起動時に一回呼び出します。
************************************/
void fnsci3Init(unsigned int bps){
    inCount3=outCount3=0;
    serial_port3.baud(bps);
    serial_port3.format(8,Serial::None,1);
    serial_port3.attach(&fngetchar3,MODSERIAL::RxIrq);      //受信の割り込み設定、割り込みがかかるとfngetchar3に飛ぶ
    memset(rBuffer3,0x00,500);
}
/************************************
関数名
    fngetchar3
引数
    無し
説明
    シリアル受信割り込み関数。
************************************/
void fngetchar3(MODSERIAL_IRQ_INFO *q){
        char ctr3;
        ctr3 = serial_port3.getc();
//      fnputchar3(cBuffer3);
        if(ctr3 == 0x0a || ctr3 == 0x0d || ctr3 == 0x1a){
            ctr3 = CR;
        }
        rBuffer3[inCount3] = ctr3;
        inCount3++;
        if(inCount3 >= 500) inCount3 = 0;
}
/************************************
関数名
    fnputchar3
引数
    シリアル送信1文字
説明
    シリアルポートに文字を1文字送信する。
************************************/
void fnputchar3(char cC){
    serial_port3.putc(cC);
}

/************************************
関数名
    fnputchar3
引数
    シリアル文字列送信
説明
    シリアル文字列を送信する。
    その後改行を送信する。
************************************/

void fnputus3(char *ucp){
    while( *ucp != '\0' ){
        if(*ucp != CR ) fnputchar3( *ucp );
        ucp++;
    }
    fnputchar3(CR);
    fnputchar3(LF);
}