#include    <string.h>
#include    <stdio.h>
#include    <stdlib.h>
//#include    <machine.h>
#include "main.h"

#define t_mode 2
#define R_mode 0        //0で返信コマンド無、1で返信コマンド有
#define checksum_mode 1

#define SWITCH1_UP 0x0001
#define SWITCH2_UP 0x0002
#define SWITCH3_UP 0x0004
#define SWITCH4_UP 0x0008
#define SWITCH5_UP 0x0010
#define SWITCH6_UP 0x0020
#define SWITCH7_UP 0x0040
#define SWITCH8_UP 0x0080

#define SWITCH9_UP 0x0100
#define SWITCH10_UP 0x0200
#define SWITCH11_UP 0x0400
#define SWITCH12_UP 0x0800
#define SWITCH13_UP 0x1000
#define SWITCH14_UP 0x2000
#define SWITCH15_UP 0x4000
#define SWITCH16_UP 0x8000

#define SW1X1 20
#define SW1X2 100
#define SW1Y1 28
#define SW1Y2 108

#define SW2X1 140
#define SW2X2 220
#define SW2Y1 28
#define SW2Y2 108

#define SW3X1 260
#define SW3X2 340
#define SW3Y1 28
#define SW3Y2 108

#define SW4X1 380
#define SW4X2 460
#define SW4Y1 28
#define SW4Y2 108

#define SW5X1 20
#define SW5X2 100
#define SW5Y1 164
#define SW5Y2 244

#define SW6X1 140
#define SW6X2 220
#define SW6Y1 164
#define SW6Y2 244

#define SW7X1 260
#define SW7X2 340
#define SW7Y1 164
#define SW7Y2 244

#define SW8X1 380
#define SW8X2 460
#define SW8Y1 164
#define SW8Y2 244

//PWM使用宣言
PwmOut PWM_PIN21(p21);
PwmOut PWM_PIN22(p22);
PwmOut PWM_PIN23(p23);
PwmOut myled1(LED1);
PwmOut myled2(LED2);
PwmOut myled3(LED3);

unsigned int math[5];
char charctor[100];
int iCountTimer;
char switch16,switch1,switch2,switch3,switch4,switch5,switch6,switch7,switch8,switch9,switch10,switch11,switch12,switch13,switch14,switch15;
int SwitchRetuNew, SwitchRetuOld, SwitchRetu_UPEDGE, SwitchRetu_DOWNEDGE;
//int iCountTimer;                    /*時間つぶし*/
int gura,autodemoflag;
int mae_gra_color,FullLED_color;      //フルカラーLEDのカラー
int iti;

//デジタルI/Oの入出力決定
//DigitalOut LED_OUT1(LED1);  //グローバル変数の様にLED_OUT1を宣言する感じ。
//DigitalOut LED_OUT2(LED2);
//DigitalOut LED_OUT3(LED3);
//DigitalOut LED_OUT4(LED4);

void ModeGamen(void);


void    fnlpc1768Init(void){
//デジタルI/Oの入出力決定の初期化をここでやろうとしたが、ダメだった。
//ここで初期化を行うと、他の関数内で使えなかった。
//同じようにシリアル通信の初期化も関数内で行えないようだ。

    //PWM1周期設定
//    myled1.period(0.001);  //周期設定(秒)
//    myled2.period(0.001);    //周期設定
//    myled3.period(0.001);    //周期設定
    
    PWM_PIN21.period(0.001); //周期設定
    PWM_PIN22.period(0.001); //周期設定
    PWM_PIN23.period(0.001); //周期設定

}

/*****************************
    関数名：atoui
    引数：ポインタ配列
    戻り値：１０進数

    10進数のようにでかかれたキャラ
    クタを、１０進数に直す。
******************************/
short atoui(char *ptr3)
{
    unsigned short v;

    for(v=0;(*ptr3 >= '0' && *ptr3 <= '9');ptr3++){
        v = v*10+(*ptr3-0x30);
    }
    return v;
}
/*****************************
    関数名：htoi
    引数：ポインタ配列
    戻り値：１０進数

    １６進数のようにでかかれたキャラ
    クタを、１０進数に直す。
******************************/
short htoi(char *ptr3)
{
    unsigned short v;

    for(v=0;(*ptr3 >= '0' && *ptr3 <= '9')||(*(ptr3) >= 'A' && *(ptr3) <= 'F')||(*(ptr3) >= 'a' && *(ptr3) <= 'f');ptr3++){
        if(*(ptr3) >= '0' && *(ptr3) <= '9') v = v*0x10+(*ptr3-0x30);
        else if(*(ptr3) >= 'A' && *(ptr3) <= 'F') v = v*0x10+(*ptr3-0x37);
        else if(*(ptr3) >= 'a' && *(ptr3) <= 'f') v = v*0x10+(*ptr3-0x57);
    }
    return v;
}
/*****************************
    関数名：htoi
    引数：ポインタ配列
    戻り値：１０進数

    １６進数のようにでかかれたキャラ
    クタを、１０進数に直す。
******************************/
int htoui(char *ptr3)
{
    unsigned int v;

    for(v=0;(*ptr3 >= '0' && *ptr3 <= '9')||(*(ptr3) >= 'A' && *(ptr3) <= 'F')||(*(ptr3) >= 'a' && *(ptr3) <= 'f');ptr3++){
        if(*(ptr3) >= '0' && *(ptr3) <= '9') v = v*0x10+(*ptr3-0x30);
        else if(*(ptr3) >= 'A' && *(ptr3) <= 'F') v = v*0x10+(*ptr3-0x37);
        else if(*(ptr3) >= 'a' && *(ptr3) <= 'f') v = v*0x10+(*ptr3-0x57);
    }
    return v;
}
/********************************************************************
    関数名：fnMath
    引数：
    戻り値：

    10進数に変換して関数へ
*********************************************************************/
char *fnMath(char *ptr)
{
    unsigned int i,j;
    i=j=0;
    for(;;){
        if(*ptr == ',' ||  *ptr == CR ){
            charctor[i] = '\0';
            math[j++] = atoui(charctor);
            i = 0;
            if( *ptr == CR ) break;
            ptr++;
        }else if(*ptr >= '0' && *ptr <= '9') charctor[i++] = *ptr++;
        else ptr++;
    }
    ptr++;
    return ptr;
}
/********************************************************************
    関数名：fnMathx
    引数：
    戻り値：

    16進数に変換して関数へ
*********************************************************************/
/*unsigned char *fnMathx(unsigned char *ptr)
{
    unsigned int i,j;
    i=j=0;
    for(;;){
        if(*ptr == ',' ||  *ptr == CR ){
            charctor[i] = '\0';
            math[j++] = htoi(charctor);
            i = 0;
            if( *ptr == CR ) break;
            ptr++;
        }else   charctor[i++] = *ptr++;
    }
    ptr++;
    return ptr;
}*/

void fnPcom(void){
    fnLCDCPaintBox(0,0,479,271,WHITE);//画面を白に塗りつぶす。
//    fnLCDCP(0,0,0,107,102,adrees)
        
}


/*********************************************************
関数名
    fnColor_LED_PWM
引数
    カラー情報
戻り値
    なし
    
説明
  この関数でカラー情報からのPWMのデューティ比を決める。
*********************************************************/
void fnColor_LED_PWM(int color){
    float red_PWM,bule_PWM,green_PWM;
    int red_bit,bule_bit,green_bit;
    
    bule_bit = color & 0x001f;
    red_bit = (color>>11) & 0x001f;
    green_bit = (color>>6) & 0x001f;//(本当は5bitずらしだけど、他の色と合わせるためG0を取り除く。)
    
    fnLCDC7seg(0,2,420,5,RED,WHITE,red_bit);
    fnLCDC7seg(0,2,420,29,GREEN,WHITE,green_bit);
    fnLCDC7seg(0,2,420,53,BLUE,WHITE,bule_bit);

                                                                             //-------------------------
    red_PWM = (red_bit * 100)/32;
    green_PWM = (green_bit * 100)/32;
    bule_PWM = (bule_bit * 100)/32;


    PWM_PIN21 = bule_PWM/100;    //(デューティ比設定 1で100%)             //ここを入れ替えるとPWMの出るpinが変わる。
    PWM_PIN22 = red_PWM/100;   //(デューティ比設定 1で100%)
    PWM_PIN23 = green_PWM/100;  //(デューティ比設定 1で100%)
}
/*********************************************************
関数名
    fncolor_map
引数
    カラーマップの左上の開始座標
戻り値
    なし
説明
    グラデーションを表示する。
**********************************************************/
void fncolor_map(int X_kijyun,int Y_kijyun){
    int col;
    int X_i,Y_i;
    
//    fnLCDCt(0);     //1データ受信要求を行い、それ以降のデータが来ないようにする。    これが無いとおそらくカラーマップを書いている間に画面を触れるとカラーマップに何点か空白ができる。
        
    col = 0xf800;
    for(Y_i=0;Y_i<32;Y_i++){
        for(X_i=0;X_i<32;X_i++){
//            fnLCDCDot(X_i+X_kijyun,Y_i+Y_kijyun,col);
            fnLCDCPaintBox(X_kijyun+(X_i*8),Y_kijyun+(Y_i*8),X_kijyun+((X_i+1)*8),Y_kijyun+((Y_i+1)*8),col);
            col= col+0x0040;    //緑を足していく。
        }            
        col = 0xf800;
        col = col - (0x0800 * (Y_i +1));
        col = col + (0x0001 * (Y_i +1));
    }
    fnLCDCPaintBoxC(X_kijyun,Y_kijyun,256+X_kijyun,256+Y_kijyun,BLACK);
    
    fnLCDCt(t_mode);  //カラーマップの描画が終了したので、通常のモードに戻す。      
}
/************************************
関数名
    fnlevel_position
引数
    無し
説明
    レベルメータを判断する。
************************************/
void fnlevel_position(void){
    iti=0;
        
    if((40<=LCDCuiX)&(LCDCuiX<48)){
        iti = 0;
    }else if((48<=LCDCuiX)&(LCDCuiX<56)){
        iti = 1;  
    }else if((56<=LCDCuiX)&(LCDCuiX<64)){
        iti = 2;
    }else if((64<=LCDCuiX)&(LCDCuiX<72)){
        iti = 3;
    }else if((72<=LCDCuiX)&(LCDCuiX<80)){
        iti = 4;
    }else if((80<=LCDCuiX)&(LCDCuiX<88)){
        iti = 5;
    }else if((88<=LCDCuiX)&(LCDCuiX<96)){
        iti = 6;
    }else if((96<=LCDCuiX)&(LCDCuiX<104)){
        iti = 7;
    }else if((104<=LCDCuiX)&(LCDCuiX<112)){
        iti = 8;
    }else if((112<=LCDCuiX)&(LCDCuiX<120)){
        iti = 9;
    }else if((120<=LCDCuiX)&(LCDCuiX<128)){
        iti = 10;
    }else if((128<=LCDCuiX)&(LCDCuiX<136)){
        iti = 11;
    }else if((136<=LCDCuiX)&(LCDCuiX<144)){
        iti = 12;
    }else if((144<=LCDCuiX)&(LCDCuiX<152)){
        iti = 13;
    }else if((152<=LCDCuiX)&(LCDCuiX<160)){
        iti = 14;
    }else if((160<=LCDCuiX)&(LCDCuiX<168)){
        iti = 15;
    }else if((168<=LCDCuiX)&(LCDCuiX<176)){
        iti = 16;
    }else if((176<=LCDCuiX)&(LCDCuiX<184)){
        iti = 17;
    }else if((184<=LCDCuiX)&(LCDCuiX<192)){
        iti = 18;
    }else if((192<=LCDCuiX)&(LCDCuiX<200)){
        iti = 19;
    }else if((200<=LCDCuiX)&(LCDCuiX<208)){
        iti = 20;
    }else if((208<=LCDCuiX)&(LCDCuiX<216)){
        iti = 21;
    }else if((216<=LCDCuiX)&(LCDCuiX<224)){
        iti = 22;
    }else if((224<=LCDCuiX)&(LCDCuiX<232)){
        iti = 23;
    }else if((232<=LCDCuiX)&(LCDCuiX<240)){
        iti = 24;
    }else if((240<=LCDCuiX)&(LCDCuiX<248)){
        iti = 25;
    }else if((248<=LCDCuiX)&(LCDCuiX<256)){
        iti = 26;
    }else if((256<=LCDCuiX)&(LCDCuiX<264)){
        iti = 27;
    }else if((264<=LCDCuiX)&(LCDCuiX<272)){
        iti = 28;
    }else if((272<=LCDCuiX)&(LCDCuiX<280)){
        iti = 29;
    }else if((280<=LCDCuiX)&(LCDCuiX<288)){
        iti = 30;
    }else if((288<=LCDCuiX)&(LCDCuiX<296)){
        iti = 31;
    }

 //   return iti;
}

/************************************
関数名
    fnlevel_color
引数
    無し
説明
    レベルメータを画面に表示し、その色を光らせる。
    ページ0へ描く。
************************************/
void fnlevel_color(void){
    char waku;
    int RED_siti,GREEN_siti,BLUE_siti;
    int RED_siti_mae,GREEN_siti_mae,BLUE_siti_mae;    

    RED_siti=0;
    GREEN_siti=0;
    BLUE_siti=0;

    RED_siti_mae=0;
    GREEN_siti_mae=0;
    BLUE_siti_mae=0;
    
//    fnLCDCcls(WHITE); //画面を白に塗りつ
    fnLCDCPaintBox(0,0,479,271,WHITE);//画面を白に塗りつぶす。
    
    fnLCDCPaintBox(40,16,296,76,0xfd96);    //赤枠
    fnLCDCPaintBox(40,16,48,76,RED);
    fnLCDCPaintBox(40,106,296,166,0xb7d6);  //緑枠
    fnLCDCPaintBox(40,106,48,166,GREEN);
    fnLCDCPaintBox(40,196,296,256,0xb59f);  //青枠
    fnLCDCPaintBox(40,196,48,256,BLUE);
    
    fnLCDCPaintBox(340,200,450,260,BLUE);   //リターンボタン表示
    for(waku = 1;waku <= 3;waku++){
        fnLCDCPaintBoxC(340+waku,200+waku,450-waku,260-waku,SILVER);
    }
    fnLCDCFont(0,1,340+5,200+40,WHITE,BLUE,"return");
    
    FullLED_color=0x0000;
    fnLCDCPaintBox(350,80,430,160,FullLED_color);       //右の隙間に選択中の色を出す。
    fnColor_LED_PWM(FullLED_color); //PWMを調整し、フルカラーLEDを光らす。
    
    while(1){
        fnSerial_Decision();
        
        //赤のレベル判断
        if((LCDCuiX >= 40) & (LCDCuiX <= 296) & (LCDCuiY >= 16) & (LCDCuiY <= 76)){
           switch1 = 1;
        }else{
           switch1 = 0;
        }
    
        //緑のレベル判断
        if((LCDCuiX >= 40) & (LCDCuiX <= 296) & (LCDCuiY >= 106) & (LCDCuiY <= 166)){
           switch2 = 1;
        }else{
           switch2 = 0;
        }        
        
        //青のレベル判断
        if((LCDCuiX >= 40) & (LCDCuiX <= 296) & (LCDCuiY >= 196) & (LCDCuiY <= 256)){
           switch3 = 1;
        }else{
           switch3 = 0;
        }        
        
        
        //スイッチ4の判断
        if((LCDCuiX >= 340) & (LCDCuiX <= 450) & (LCDCuiY >= 200) & (LCDCuiY <= 260)){
           switch4 = 1;
        }else{
           switch4 = 0;
        }
        SwitchRetuOld = SwitchRetuNew;  //一周前のスイッチの状態を保持。
        SwitchRetuNew = (switch1 | switch2<<1 | switch3<<2 | switch4<<3 | switch5<<4 | switch6<<5 | switch7<<6 | switch8<<7 | switch9<<8 | switch10<<9 | switch11<<10 | switch12<<11 | switch13<<12 | switch14<<13 | switch15<<14 | switch16<<15);

        SwitchRetu_UPEDGE = ((SwitchRetuOld | SwitchRetuNew)^SwitchRetuOld);//立ち上がり時判定
        SwitchRetu_DOWNEDGE = ((SwitchRetuOld | SwitchRetuNew)^SwitchRetuNew);//立

    
        mae_gra_color = FullLED_color;      //選択されている色をmae_に入れ、記憶させる。

//スイッチ１  赤レベル
//        if(SwitchRetu_UPEDGE & SWITCH1_UP){     //ｽｲｯﾁ1立ち上がりエッジ検出
  //          for(waku = 1;waku <= 3;waku++){
             //   fnLCDCPaintBoxC(340+waku,200+waku,450-waku,260-waku,GRAY);
    //        }
      //  }
      //  if(SwitchRetu_DOWNEDGE & SWITCH1_UP){   //ｽｲｯﾁ1立下りエッジ検出
//            for(waku = 1;waku <= 3;waku++){
//             //   fnLCDCPaintBoxC(340+waku,200+waku,450-waku,260-waku,SILVER);
//            }
//        }
        if(switch1){
            fnlevel_position();
            RED_siti = iti;
            if(RED_siti_mae != RED_siti){
                fnLCDCPaintBox(RED_siti_mae*8+40,16,RED_siti_mae*8+48,76,0xfd96);
                fnLCDCPaintBox(RED_siti*8+40,16,RED_siti*8+48,76,RED);
                RED_siti_mae = RED_siti;
            }
        }
            

//スイッチ２  緑レベル
        if(switch2){
            fnlevel_position();
            GREEN_siti = iti;
            if(GREEN_siti_mae != GREEN_siti){
                fnLCDCPaintBox(GREEN_siti_mae*8+40,106,GREEN_siti_mae*8+48,166,0xb7d6);
                fnLCDCPaintBox(GREEN_siti*8+40,106,GREEN_siti*8+48,166,GREEN);
                GREEN_siti_mae = GREEN_siti;
            }
        }

//スイッチ３  青レベル
        if(switch3){
            fnlevel_position();
            BLUE_siti = iti;
            if(BLUE_siti_mae != BLUE_siti){
                fnLCDCPaintBox(BLUE_siti_mae*8+40,196,BLUE_siti_mae*8+48,256,0xb59f);
                fnLCDCPaintBox(BLUE_siti*8+40,196,BLUE_siti*8+48,256,BLUE);
                BLUE_siti_mae = BLUE_siti;
            }
        }   
//スイッチ4        
        if(SwitchRetu_UPEDGE & SWITCH4_UP){     //ｽｲｯﾁ4立ち上がりエッジ検出
            for(waku = 1;waku <= 3;waku++){
                fnLCDCPaintBoxC(340+waku,200+waku,450-waku,260-waku,GRAY);
            }
        }
        
        FullLED_color = (RED_siti<<11)|(GREEN_siti<<6)|(BLUE_siti);
        
        if(mae_gra_color != FullLED_color){
            fnLCDCPaintBox(350,80,430,160,FullLED_color);       //右の隙間に選択中の色を出す。
            fnColor_LED_PWM(FullLED_color); //PWMを調整し、フルカラーLEDを光らす。
        }
        
        if(SwitchRetu_DOWNEDGE & SWITCH4_UP){   //ｽｲｯﾁ4立下りエッジ検出
            for(waku = 1;waku <= 3;waku++){
                fnLCDCPaintBoxC(340+waku,200+waku,450-waku,260-waku,SILVER);
            }
            SwitchRetu_DOWNEDGE= 0x0000;
            fnColor_LED_PWM(0x0000);//フルカラーLEDを消灯する。
            return;
        }
        
    }
}
/************************************
関数名
    fncolor＿indexing
引数
    無し
戻り値
    カラー情報

説明
    グラデーションのどの色が選択されているかを調べる。
************************************/
int fncolor_indexing(void){
//LCDCuiX,LCDCuiY;
    int gra_color,sentaku_color;
    int X_i,Y_i;
    gra_color = 0xf800;
//    sentaku_color = 0x0000;
    for(Y_i=0;Y_i<32;Y_i++){
        for(X_i=0;X_i<32;X_i++){
//            fnLCDCDot(X_i+X_kijyun,Y_i+Y_kijyun,col);
//            fnLCDCPaintBox(X_kijyun+(X_i*8),Y_kijyun+(Y_i*8),X_kijyun+((X_i+1)*8),Y_kijyun+((Y_i+1)*8),col);
            if(40+X_i*8 < LCDCuiX && 40+(X_i+1)*8 > LCDCuiX && 8+Y_i*8 < LCDCuiY && 8+(Y_i+1)*8 > LCDCuiY){
               // fnLCDCPaintBox(350,80,430,160,gra_color);
                sentaku_color=gra_color;
            }

            gra_color= gra_color+0x0040;    //緑を足していく。
        }            
        gra_color = 0xf800;
        gra_color = gra_color - (0x0800 * (Y_i +1));
        gra_color = gra_color + (0x0001 * (Y_i +1));
    }
    return sentaku_color;
}  
/************************************
関数名
    fngradation_color
引数
    無し
説明
    グラデーションを画面に表示し、その色を光らせる。
    グラデーションはページ1へ描く。
************************************/
void fngradation_color(void){
    char waku;
    
    fnLCDCI(1);     //書き込みページをページ1に変更（画面に表示している画像はこの時はまだページ0）
//    fnLCDCcls(WHITE); //画面を白に塗りつぶす。


//----------------- 1ページ目に書き込む

    fnLCDCPaintBox(0,0,479,271,WHITE);//画面を白に塗りつぶす。
    wait(0.5);
    fncolor_map(40,8);   //カラーマップを表示
    fnLCDCPaintBox(340,200,450,260,BLUE);   //ボタン表示
    for(waku = 1;waku <= 3;waku++){
        fnLCDCPaintBoxC(340+waku,200+waku,450-waku,260-waku,SILVER);
    }
    fnLCDCFont(0,1,340+5,200+40,WHITE,BLUE,"return");

//------------------

    
    fnLCDCH(1);     //表示ページをページ1に変更し、既にページ1に書き終わっているグラデーションを表示する。
    
    FullLED_color=0x0000;
    fnLCDCPaintBox(350,80,430,160,FullLED_color);       //右の隙間に選択中の色を出す。
    fnColor_LED_PWM(FullLED_color); //PWMを調整し、フルカラーLEDを光らす。
    
    while(1){
        //指座標の確保
        fnSerial_Decision();
        //スイッチの確認
        //スイッチ1の判断
        if((LCDCuiX >= 40) & (LCDCuiX <= 296) & (LCDCuiY >= 8) & (LCDCuiY <= 264)){
            switch1 = 1;
        }else{
            switch1 = 0;
        }
        //スイッチ2の判断
        if((LCDCuiX >= 340) & (LCDCuiX <= 450) & (LCDCuiY >= 200) & (LCDCuiY <= 260)){
           switch2 = 1;
        }else{
           switch2 = 0;
        }
        SwitchRetuOld = SwitchRetuNew;  //一周前のスイッチの状態を保持。
        SwitchRetuNew = (switch1 | switch2<<1 | switch3<<2 | switch4<<3 | switch5<<4 | switch6<<5 | switch7<<6 | switch8<<7 | switch9<<8 | switch10<<9 | switch11<<10 | switch12<<11 | switch13<<12 | switch14<<13 | switch15<<14 | switch16<<15);

        SwitchRetu_UPEDGE = ((SwitchRetuOld | SwitchRetuNew)^SwitchRetuOld);//立ち上がり時判定
        SwitchRetu_DOWNEDGE = ((SwitchRetuOld | SwitchRetuNew)^SwitchRetuNew);//立
    
        mae_gra_color = FullLED_color;
    
        if(switch1 == 1){
            FullLED_color= fncolor_indexing();
        }

        if(SwitchRetu_UPEDGE & SWITCH2_UP){     //ｽｲｯﾁ2立ち上がりエッジ検出
            for(waku = 1;waku <= 3;waku++){
                fnLCDCPaintBoxC(340+waku,200+waku,450-waku,260-waku,GRAY);
            }
        }
        if(SwitchRetu_DOWNEDGE & SWITCH2_UP){   //ｽｲｯﾁ2立下りエッジ検出
            for(waku = 1;waku <= 3;waku++){
                fnLCDCPaintBoxC(340+waku,200+waku,450-waku,260-waku,SILVER);
            }
            SwitchRetu_DOWNEDGE= 0x0000;
            fnColor_LED_PWM(0x0000);//フルカラーLEDを消灯する。
            return;
        }
        if(mae_gra_color != FullLED_color){
            fnLCDCPaintBox(350,80,430,160,FullLED_color);   //右に四角で今の選択中の色を出す。
            fnColor_LED_PWM(FullLED_color); //PWMを調整し、フルカラーLEDを光らす。
        }
    }
}

void fnautodmeo(void){
    if(autodemoflag == 1){
    }
}
/************************************
関数名
    fnColor_pick_gamen
引数
    無し
説明
    スイッチ二つを画面へ描く。
    起動時と各機能から戻ってきた時に呼び出す。
************************************/
void fncolor_pick_gamen(void){
    char waku;
//    fnLCDCcls(WHITE); //画面を白に塗りつぶす。
    fnLCDCPaintBox(0,0,479,271,WHITE);//画面を白に塗りつぶす。

    fnLCDCFont(0,1,80+5,20+40,GREEN,WHITE,"FULLColorLED  - Controller ");

    fnLCDCPaintBox(60,80,180,190,BLUE);
    for(waku = 1;waku <= 3;waku++){
        fnLCDCPaintBoxC(60+waku,80+waku,180-waku,190-waku,SILVER);
    }
    fnLCDCFont(0,1,60+5,80+40,WHITE,BLUE,"level");

    fnLCDCPaintBox(300,80,420,190,BLUE);
    for(waku = 1;waku <= 3;waku++){
        fnLCDCPaintBoxC(300+waku,80+waku,420-waku,190-waku,SILVER);
    }
    fnLCDCFont(0,1,300+5,80+40,WHITE,BLUE,"gradation");
    
//    fnLCDCPaintBox(300,160,420,200,BLUE);
//    for(waku = 1;waku <= 3;waku++){
//        fnLCDCPaintBoxC(300+waku,160+waku,420-waku,200-waku,SILVER);
//    }
//    fnLCDCFont(0,1,300+5,160+40,WHITE,BLUE,"return");
}
/************************************
関数名
    fnColor_pick_switch
引数
    無し
説明
    スイッチ変数の状態を調べ、各機能を実行する。
************************************/
int fncolor_pick_switch(void){
    char waku;
//    int kaisuu;

    if(SwitchRetu_UPEDGE & SWITCH1_UP){     //ｽｲｯﾁ1立ち上がりエッジ検出
        for(waku = 1;waku <= 3;waku++){
            fnLCDCPaintBoxC(60+waku,80+waku,180-waku,190-waku,GRAY);
        }
    }
    if(SwitchRetu_DOWNEDGE & SWITCH1_UP){   //ｽｲｯﾁ1立下りエッジ検出
        for(waku = 1;waku <= 3;waku++){
            fnLCDCPaintBoxC(60+waku,80+waku,180-waku,190-waku,SILVER);
        }
        fnlevel_color();        //レベルバーカラーデモ
        fncolor_pick_gamen();
    }
    if(SwitchRetu_UPEDGE & SWITCH2_UP){     //ｽｲｯﾁ2立ち上がりエッジ検出
        for(waku = 1;waku <= 3;waku++){
            fnLCDCPaintBoxC(300+waku,80+waku,420-waku,190-waku,GRAY);
        }
    }
    if(SwitchRetu_DOWNEDGE & SWITCH2_UP){   //ｽｲｯﾁ2立下りエッジ検出
        for(waku = 1;waku <= 3;waku++){
            fnLCDCPaintBoxC(300+waku,80+waku,420-waku,190-waku,SILVER);
        }
        fngradation_color();
        fnLCDCI(0);     //書き込みページをページ0に戻す。
        fncolor_pick_gamen();       //グラデーションカラーデモ
        fnLCDCH(0);     //表示ページをページ0に戻す。
    }
    if(SwitchRetu_UPEDGE & SWITCH3_UP){     //ｽｲｯﾁ3立ち上がりエッジ検出
        for(waku = 1;waku <= 3;waku++){
            fnLCDCPaintBoxC(300+waku,190+waku,420-waku,200-waku,GRAY);
        }
    }
    if(SwitchRetu_DOWNEDGE & SWITCH3_UP){   //ｽｲｯﾁ3立下りエッジ検出
        for(waku = 1;waku <= 3;waku++){
            fnLCDCPaintBoxC(300+waku,190+waku,420-waku,200-waku,SILVER);
        }
        SwitchRetu_DOWNEDGE = 0x0000;
        return 1;
    }
    return 0;
}
/************************************
関数名
    fnColor_pick_switchhandan
引数
    無し
説明
    画面スイッチの判断を行い変数へ格納する。
************************************/
void fncolor_pick_switchhandan(void){

//スイッチ1の判断
    if((LCDCuiX >= 60) & (LCDCuiX <= 180) & (LCDCuiY >= 80) & (LCDCuiY <= 190)){
        switch1 = 1;
    }else{
        switch1 = 0;
    }
//スイッチ2の判断
    if((LCDCuiX >= 300) & (LCDCuiX <= 420) & (LCDCuiY >= 80) & (LCDCuiY <= 190)){
        switch2 = 1;
    }else{
        switch2 = 0;
    }
//スイッチ3の判断
//    if((LCDCuiX >= 300) & (LCDCuiX <= 420) & (LCDCuiY >= 160) & (LCDCuiY <= 200)){
//        switch3 = 1;
//    }else{
//        switch3 = 0;
//    }
    
    SwitchRetuOld = SwitchRetuNew;  //一周前のスイッチの状態を保持。
    SwitchRetuNew = (switch1 | switch2<<1 | switch3<<2 | switch4<<3 | switch5<<4 | switch6<<5 | switch7<<6 | switch8<<7 | switch9<<8 | switch10<<9 | switch11<<10 | switch12<<11 | switch13<<12 | switch14<<13 | switch15<<14 | switch16<<15);

    SwitchRetu_UPEDGE = ((SwitchRetuOld | SwitchRetuNew)^SwitchRetuOld);//立ち上がり時判定
    SwitchRetu_DOWNEDGE = ((SwitchRetuOld | SwitchRetuNew)^SwitchRetuNew);//立ち下が時判定
    
}
/************************************
関数名
    fnColor_pick
引数
    無し
説明
    画面に2つのスイッチを描き、そのスイッチの判断を行う。
************************************/
void fncolor_pick(void){
    fncolor_pick_gamen();
    
    while(1){
        fnSerial_Decision();
        fncolor_pick_switchhandan();
        if(fncolor_pick_switch()==1){
            return;
        }
        
    }
}

/************************************
関数名
    main
引数
    無し
説明
    main関数
    初期設定とsmartLCDCの設定を行う。
************************************/
int main() {
    char waku;
    //各モジュールの初期化
    fnlpc1768Init();
    fnLCDCInit();
    fnsci3Init(115200); //シリアル通信の初期化、引数はbps
    wait(1);    //電源投入後、コマンドドリブンにコマンドを送るのをしばらく待つ。
    fnLCDCt(0); //ダミーでt0を送る。このコマンドは受信されないことを前提として送信、相手側の受信部を整え、次のコマンドを確実に受け取らせる。
    wait(0.1);
    
    fnLCDCt(t_mode);        //tコマンドでタッチパネルデータ取得モードを決める。
    fnLCDCR(R_mode);      //受信コマンドの有無を決める。
    fnLCDC_RTSset(1);       //RTSを無視(0)  受信(1)
//    fnLCDCU(1);             //チェックサム  有(1) 無(0)
    wait(0.1);
//    fnPcom();


/*
//----ページ1を書いておく。
    fnLCDCI(1);     //書き込みページをページ1に変更（画面に表示している画像はこの時はまだページ0）
//    fnLCDCcls(WHITE); //画面を白に塗りつぶす。
    fnLCDCPaintBox(0,0,479,271,WHITE);//画面を白に塗りつぶす。
    fncolor_map(40,8);   //カラーマップを表示
    fnLCDCPaintBox(340,200,450,260,BLUE);   //ボタン表示
    for(waku = 1;waku <= 3;waku++){
        fnLCDCPaintBoxC(340+waku,200+waku,450-waku,260-waku,SILVER);
    }
    fnLCDCFont(0,1,340+5,200+40,WHITE,BLUE,"return");
    fnLCDCI(0);     //書き込みページを0に戻す。
    
//-------------   
*/
    while(1){
     fncolor_pick();
    }
}