#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "command_LCDClib.h"
#include "color.h"
#include "main.h"        /* 共通   */

unsigned short LCDCuiX,LCDCuiY;
char LCDC_Command[100];
char serialDataBuff3[500];
//char cBuffer[500];
char *string1;
char string2[45];
unsigned short LCDCFontX,LCDCFontY;
unsigned char LCDCFontcl1,LCDCFontcl2;
char hexbuf[8];
int command_returncheck_flag;
int checksum_command_flag;
int return_command_flag;
int RTS_flag;
//デジタルI/Oの入出力決定
DigitalIn RTS_PIN(p29);
DigitalOut LED_OUT1(LED1);  //グローバル変数の様にLED_OUT1を宣言する感じ。
/**************************************
関数名
    LCDCInit
引数：なし
戻り値：なし
説明：CommandLCDClibで使用しているフラグの初期化
　　　main.cの開始に一度呼ぶ。
**************************************/
void fnLCDCInit(void)
{
    DigitalIn RTS_PIN(p29);
    command_returncheck_flag= 0;
    checksum_command_flag = 0;
    return_command_flag = 0;
    RTS_flag = 0;

}
/**************************************
関数名
    tohex
引数：int10進数
戻り値：なし
説明：intタイプの10進数を16進数の文字列に変換
**************************************/
void tohex1(unsigned int ptr)
{

    if(10 > ptr%16) {
        hexbuf[0] = ptr%16 + 0x30;
    } else {
        hexbuf[0] = (ptr%16) + 0x37;
    }

    hexbuf[1] = '\0';
}

void tohex2(unsigned int ptr)
{
    if(10 > ptr%16) {
        hexbuf[1] = ptr%16 + 0x30;
    } else {
        hexbuf[1] = (ptr%16) + 0x37;
    }

    ptr = ptr/16;

    if(10 > ptr%16) {
        hexbuf[0] = ptr%16 + 0x30;
    } else {
        hexbuf[0] = (ptr%16) + 0x37;
    }

    hexbuf[2] = '\0';
}

void tohex3(unsigned int ptr)
{

    if(10 > ptr%16) {
        hexbuf[2] = ptr%16 + 0x30;
    } else {
        hexbuf[2] = (ptr%16) + 0x37;
    }

    ptr = ptr/16;

    if(10 > ptr%16) {
        hexbuf[1] = ptr%16 + 0x30;
    } else {
        hexbuf[1] = (ptr%16) + 0x37;
    }

    ptr = ptr/16;

    if(10 > ptr%16) {
        hexbuf[0] = ptr%16 + 0x30;
    } else {
        hexbuf[0] = (ptr%16) + 0x37;
    }

    hexbuf[3] = '\0';

}

void tohex4(unsigned int ptr)
{

    if(10 > ptr%16) {
        hexbuf[3] = ptr%16 + 0x30;
    } else {
        hexbuf[3] = (ptr%16) + 0x37;
    }

    ptr = ptr/16;

    if(10 > ptr%16) {
        hexbuf[2] = ptr%16 + 0x30;
    } else {
        hexbuf[2] = (ptr%16) + 0x37;
    }

    ptr = ptr/16;

    if(10 > ptr%16) {
        hexbuf[1] = ptr%16 + 0x30;
    } else {
        hexbuf[1] = (ptr%16) + 0x37;
    }

    ptr = ptr/16;

    if(10 > ptr%16) {
        hexbuf[0] = ptr%16 + 0x30;
    } else {
        hexbuf[0] = (ptr%16) + 0x37;
    }

    hexbuf[4] = '\0';

}
void tohex8(unsigned int ptr)
{
    if(10 > ptr%16) {
        hexbuf[7] = ptr%16 + 0x30;
    } else {
        hexbuf[7] = (ptr%16) + 0x37;
    }

    if(10 > ptr%16) {
        hexbuf[6] = ptr%16 + 0x30;
    } else {
        hexbuf[6] = (ptr%16) + 0x37;
    }

    if(10 > ptr%16) {
        hexbuf[5] = ptr%16 + 0x30;
    } else {
        hexbuf[5] = (ptr%16) + 0x37;
    }
    
    if(10 > ptr%16) {
        hexbuf[4] = ptr%16 + 0x30;
    } else {
        hexbuf[4] = (ptr%16) + 0x37;
    }
    
    if(10 > ptr%16) {
        hexbuf[3] = ptr%16 + 0x30;
    } else {
        hexbuf[3] = (ptr%16) + 0x37;
    }

    ptr = ptr/16;

    if(10 > ptr%16) {
        hexbuf[2] = ptr%16 + 0x30;
    } else {
        hexbuf[2] = (ptr%16) + 0x37;
    }

    ptr = ptr/16;

    if(10 > ptr%16) {
        hexbuf[1] = ptr%16 + 0x30;
    } else {
        hexbuf[1] = (ptr%16) + 0x37;
    }

    ptr = ptr/16;

    if(10 > ptr%16) {
        hexbuf[0] = ptr%16 + 0x30;
    } else {
        hexbuf[0] = (ptr%16) + 0x37;
    }

    hexbuf[8] = '\0';

}
/**************************************
関数名
    tochecsum
引数
   ptr:変更するチェックサム
戻り値：なし
説明：チェックサムを文字列にする。
**************************************/
void tochecksum(unsigned int ptr)
{
    hexbuf[1] = ptr%16 + 0x30;

    ptr = ptr/16;
    hexbuf[0] = ptr%16 + 0x30;
    hexbuf[2] = '\0';
}
/**************************************
関数名
    returncheck
引数：なし
戻り値：なし
説明：リターンコマンドが有効な場合、リターンコマンドの受信を待つ。
**************************************/
void returncheck(void)
{
    int maticount1,maticount2;
    command_returncheck_flag = 1;       //flagを立てる


//  while(command_returncheck_flag== 1){    //flagが降りるまで返信コマンドをまつ
//      fnSerial_Decision();
//  }


//--------↓forを65535回繰り返すだけでは、画面全体の塗りつぶしの際、返信コマンドが間に合ってないので2重のfor
    for(maticount1 = 0; maticount1 < 0xffff; maticount1++) {
        for(maticount2 = 0; maticount2 < 0xffff; maticount2++) {
            fnSerial_Decision();
            if(command_returncheck_flag== 0) {
                break;
            }
        }
        if(command_returncheck_flag== 0) {
            break;
        }
    }
}
/**************************************
関数名
    fnMake_sum_and_Trans
引数：なし
戻り値：なし
説明：コマンドを送信する。
     RTSが有効な場合、RTSを読み取りLowになるまで待機する。
     チェックサムが有効な場合、チャックサムを作りコマンドの後に接続する。
**************************************/
void fnMake_sum_and_Trans(void)
{
    int i;
    unsigned char checksum;

    i = 0;
    checksum = '\0';

    if(RTS_flag == 1) {
        if(RTS_PIN == 1){
            LED_OUT1 = 1;
        }
        while(RTS_PIN == 1);
        LED_OUT1 = 0;
    }
    if(checksum_command_flag == 1) {    //チェックサムの設定が有(1)の場合チェックサムを作る。
        while(string1[i] != '\0') {
            checksum += string1[i];
            i++;
        }
        i=0;
        while(string2[i] != '\0') {
            checksum += string2[i];
            i++;
        }
        tochecksum(checksum);
        strcat(string2,hexbuf);
        //          string2 += hexbuf;
    }

    strcpy(LCDC_Command,string1);           //LCDC_Commandにstring1をコピー
    strcat(LCDC_Command,string2);           //LCDC_Commandにstring2を付け加え。

    fnputus3(LCDC_Command);      //コマンド文を送信

    if(return_command_flag == 1) {
        returncheck();
    }

}

/******************************************************
関数名
    fnLCDCT

説明
    タッチパネルデータの取得間隔の設定

＜時間間隔＞
    50ms(0x32)～200ms(0xC8)まで設定可能
*********************************************************/
void fnLCDCT(unsigned int mSecond)
{
    string1 = "T";

    tohex2(mSecond);
    strcpy(string2,hexbuf);         //もしtypeが付くなら　strcpyをstrcatにするように。

    fnMake_sum_and_Trans();
}

/******************************************************
        関数名 fnLCDCt

        説明 タッチパネルデータの取得条件の設定

＜種別＞
0:1データ受信
1:動で連続受信
2:押されている間連続受信
3:押されたときだけ受信
4:されたときだけ受信
5の両方の２データ受信

*********************************************************/
void fnLCDCt(unsigned int type)
{
    string1 = "t";

    tohex1(type);
    strcpy(string2,hexbuf);

    fnMake_sum_and_Trans();
}

/******************************************************
        関数名 fnLCDCH

        説明 表示ページの設定

＜種別＞
0:0ページ（デフォルト）
1:1ページ
*********************************************************/
void fnLCDCH(unsigned int type)
{
    string1 = "H";

    tohex1(type);
    strcpy(string2,hexbuf);

    fnMake_sum_and_Trans();
}
/******************************************************
関数名 fnLCDCI

説明 書き込みページの設定

＜種別＞
0:0ページにセット（デフォルト）
1:1ページにセット

*********************************************************/
void fnLCDCI(unsigned int type)
{
    string1 = "I";

    tohex1(type);
    strcpy(string2,hexbuf);

    fnMake_sum_and_Trans();
}

/*******************************************************
関数名
    fnLCDCU

説明　
    チェックサムの有無の設定

0:チェックサム無に設定
1:チェックサム有に設定
*******************************************************/
void fnLCDCU(unsigned int type)
{
    string1 = "U";
//      unsigned char string2[2];

    tohex1(type);
    strcpy(string2,hexbuf);
    //checksumの値変更

    fnMake_sum_and_Trans();
    if(type == 1) {
        checksum_command_flag = 1;
    } else {
        checksum_command_flag = 0;
    }
}


/*******************************************************
関数名：fnLCDCR
引数：type 0:返信コマンド無に設定
            1:返信コマンド有に設定
説明：各コマンドへの返信の有無の設定
*******************************************************/
void fnLCDCR(unsigned int type)
{
    string1 = "R";

    tohex1(type);
    strcpy(string2,hexbuf);
    if(type == 1) {
        return_command_flag = 1;
    } else {
        return_command_flag = 0;
    }
    fnMake_sum_and_Trans();
}
/***********************************
    関数名：fnLCDCDot
    引数：
    　　　(uiX,uiY)　点の座標
　　　　　ucC　色
    戻り値：なし
    説明：任意の座標に任意色で点を描く
***********************************/
void fnLCDCDot(unsigned int uiX,unsigned int uiY,unsigned int ucC)
{
    string1 = "D";
    //uiXの代入
    tohex3(uiX);
    strcpy(string2,hexbuf);

    //uiYの代入
    tohex3(uiY);
    strcat(string2,hexbuf);

    //ucCの代入
    tohex4(ucC);
    strcat(string2,hexbuf);
//      string2[10] = '\0';

    fnMake_sum_and_Trans();
}
/***********************************
    関数名：fnLCDCLine
    引数：type　0:通常線
                1:点線
                2:結線
    　　　(uiX1,uiY1)　直線の始点座標
        　(uiX2,uiY2)　直線の終点座標
　　　　　ucC　色
    戻り値：なし
    説明：任意の座標から座標に任意色で線を描く
***********************************/
void    fnLCDCLine(unsigned int uiX1,unsigned int uiY1,unsigned int uiX2,unsigned int uiY2,unsigned int ucC)
{
    string1 ="L0";

    tohex3(uiX1);
    strcpy(string2,hexbuf);

    tohex3(uiY1);
    strcat(string2,hexbuf);

    tohex3(uiX2);
    strcat(string2,hexbuf);

    tohex3(uiY2);
    strcat(string2,hexbuf);

    tohex4(ucC);
    strcat(string2,hexbuf);

    fnMake_sum_and_Trans();
}
/***********************************
    関数名：fnLCDCLineS
    引数：type　0:通常線
                1:点線
                2:結線
    　　　(uiX1,uiY1)　直線の始点座標
        　(uiX2,uiY2)　直線の終点座標
　　　　　ucC　色
    戻り値：なし
    説明：任意の座標から座標に任意色で線を描く(点線、結線)
***********************************/
void    fnLCDCLineS(unsigned int type,unsigned int uiX1,unsigned int uiY1,unsigned int uiX2,unsigned int uiY2,unsigned int ucC)
{
    string1 ="L";

    tohex1(type);
    strcpy(string2,hexbuf);

    tohex3(uiX1);
    strcat(string2,hexbuf);

    tohex3(uiY1);
    strcat(string2,hexbuf);

    tohex3(uiX2);
    strcat(string2,hexbuf);

    tohex3(uiY2);
    strcat(string2,hexbuf);

    tohex4(ucC);
    strcat(string2,hexbuf);

    fnMake_sum_and_Trans();
}
/***********************************
    関数名：fnLCDCPaintBox
    引数：(uiX1,uiY1)　四角の左上の座標
        　(uiX2,uiY2)　四角の右下の座標
　　　　　ucC　色
    戻り値：なし
    説明：四角を任意の大きさ・色で描く（塗りつぶし）
***********************************/
void fnLCDCPaintBox(unsigned int uiX1,unsigned int uiY1,unsigned int uiX2,unsigned int uiY2,unsigned int ucC)
{
    string1 = "B0";

    tohex3(uiX1);
    strcpy(string2,hexbuf);

    tohex3(uiY1);
    strcat(string2,hexbuf);

    tohex3(uiX2);
    strcat(string2,hexbuf);

    tohex3(uiY2);
    strcat(string2,hexbuf);

    tohex4(ucC);
    strcat(string2,hexbuf);

    fnMake_sum_and_Trans();
}


/***********************************
    関数名：fnLCDCPaintBoxC
    引数：(uiX1,uiY1)　四角の左上の座標
        　(uiX2,uiY2)　四角の右下の座標
　　　　　ucC　色
    戻り値：なし
    説明：四角を任意の大きさ・色で描く（枠）
***********************************/
void fnLCDCPaintBoxC(unsigned int uiX1,unsigned int uiY1,unsigned int uiX2,unsigned int uiY2,unsigned int ucC)
{
//   コマンド[B]ボックス　種別[1]枠

    string1 = "B1";

    tohex3(uiX1);
    strcpy(string2,hexbuf);

    tohex3(uiY1);
    strcat(string2,hexbuf);

    tohex3(uiX2);
    strcat(string2,hexbuf);

    tohex3(uiY2);
    strcat(string2,hexbuf);

    tohex4(ucC);
    strcat(string2,hexbuf);

    fnMake_sum_and_Trans();
}
/***********************************
    関数名：fnLCDCcls2
    引数：ucC　色
    戻り値：なし
    説明：画面全体を任意色で塗りつぶす
***********************************/
void fnLCDCcls(unsigned int ucC)
{
    fnLCDCPaintBox(0,0,LCDC_XSCL-1,LCDC_XSCL-1,ucC);
}
/*********************************************************************
    関数名
        cls2ブラインド(クリアスクリーン)
    引数
        ucColor
    戻り値
        なし
    説明
        320×240ドットの全エリアを指定した単色で塗る（クリア）
        
**********************************************************************/
void    fnLCDCcls2(unsigned char ucColor)
{
    unsigned int  uiY,uiN;

    for(uiN = 0; uiN < 20 ;uiN++ ){
        for(uiY = 0 ; uiY < LCDC_YSCL ; uiY+=20 ){
            fnLCDCLine(0,uiY+uiN,0,uiY+uiN,ucColor);
        }
    }
}

/***********************************
    関数名：fnLCDCCircle
    引数：type 0:通常円
                1:縦円柱
                2:横円柱
　　　　　(uiX,uiY)： 円の中心座標
        　(radX,radY) : 円の縦半径、横半径
        　high：円柱の高さ
        　framecol：円柱の枠の色
        　col：円柱表面の色
    戻り値：なし
    説明：任意の場所に円、または円柱を描く
***********************************/
void fnLCDCCircle(unsigned int type,unsigned int uiX,unsigned int uiY,unsigned int radX,unsigned int radY,unsigned int high,unsigned int framecol,unsigned int col)
{

    string1 = "C";

    tohex1(type);
    strcpy(string2,hexbuf);

    tohex3(uiX);
    strcat(string2,hexbuf);

    tohex3(uiY);
    strcat(string2,hexbuf);

    tohex3(radX);
    strcat(string2,hexbuf);

    tohex3(radY);
    strcat(string2,hexbuf);

    tohex3(high);
    strcat(string2,hexbuf);

    tohex4(framecol);
    strcat(string2,hexbuf);

    tohex4(col);
    strcat(string2,hexbuf);

    fnMake_sum_and_Trans();
}
/***********************************
    関数名：fnLCDCFont
    引数：type：フォント種類
                0：16ドット
                1：24ドット
        　size：文字サイズ
                0：通常
                1：縦倍角
                2：横倍角
                3：縦横倍角
        　(uiX,uiY)　：文字描画の開始座標
　　　　　col：文字色
        　ucp：文字のアドレス
        　offcol：文字の背景色
    戻り値：なし
    説明：四角を任意の大きさ・色で描く（枠）
***********************************/
void fnLCDCFont(unsigned int type,unsigned int size,unsigned int uiX,unsigned int uiY,unsigned int col, unsigned int offcol,char *ucp)
{
    string1="F";

    tohex1(type);
    strcpy(string2,hexbuf);

    tohex1(size);
    strcat(string2,hexbuf);

    tohex3(uiX);
    strcat(string2,hexbuf);

    tohex3(uiY);
    strcat(string2,hexbuf);

    tohex4(col);
    strcat(string2,hexbuf);

    tohex4(offcol);
    strcat(string2,hexbuf);

    strcat(string2,ucp);            //string2にフォント文字列をつけ加える。

    fnMake_sum_and_Trans();
}
/*********************************************************************
    関数名
        fnLCDC7seg
    引数
        size    0：サイズ1
                1：サイズ2
        cColum  表示桁数  最大5桁まで
        uiX,uiY 原点のX,Y座標(7segの左上座標）
        col     表示色
        offcol  消灯色
        iValue  表示する数値
    戻り値
        なし
    説明
        引数で数値を渡すと、n桁の7segパターンを表示する
　　　　ゼロサプレスは未定
        数値より少ない桁数の場合は、右詰でツジツマが合うように
        表示する。

**********************************************************************/
void fnLCDC7seg(unsigned int size,unsigned int cColum,unsigned int uiX,unsigned int uiY,unsigned int col,unsigned int offcol,int iValue)
{
    char string3[6];

    string1="S";

    tohex1(size);
    strcpy(string2,hexbuf);

    tohex1(cColum);
    strcat(string2,hexbuf);

    tohex3(uiX);
    strcat(string2,hexbuf);

    tohex3(uiY);
    strcat(string2,hexbuf);

    tohex4(col);
    strcat(string2,hexbuf);

    tohex4(offcol);
    strcat(string2,hexbuf);
    if(cColum == 1) {
        string3[0] = (iValue%10) + 0x30;
        string3[1] = '\0';

    }
    if(cColum == 2) {
        string3[0] = ((iValue/10)%10) + 0x30;
        string3[1] = (iValue%10) + 0x30;
        string3[2] = '\0';
    }
    if(cColum == 3) {
        string3[0] = ((iValue/100)%10) + 0x30;
        string3[1] = ((iValue/10)%10) + 0x30;
        string3[2] = (iValue%10) + 0x30;
        string3[3] = '\0';
    }
    if(cColum == 4) {
        string3[0] = ((iValue/1000)%10) + 0x30;
        string3[1] = ((iValue/100)%10) + 0x30;
        string3[2] = ((iValue/10)%10) + 0x30;
        string3[3] = (iValue%10) + 0x30;
        string3[4] = '\0';
    }
    if(cColum == 5) {
        string3[0] = ((iValue/10000)%10) + 0x30;
        string3[1] = ((iValue/1000)%10) + 0x30;
        string3[2] = ((iValue/100)%10) + 0x30;
        string3[3] = ((iValue/10)%10) + 0x30;
        string3[4] = (iValue%10) + 0x30;
        string3[5] = '\0';
    }

    strcat(string2,string3);

    fnMake_sum_and_Trans();
}
/*********************************************************************
    関数名
        fnLCDCP
    引数
        type    0：単一＜シリアルフラッシュロムから＞
                1：連続表示＜シリアルフラッシュロムから＞サイズが同一に限る
                2：単一＜microSDから＞
                3：連続表示＜microSDから＞サイズが同一に限る
        uiX,uiY 原点のX,Y座標(画像の左上座標）
        Xsize 画像横幅のサイズ
        Ysize 画像縦幅のサイズ
        adrees 先頭保存アドレス
    戻り値
        なし
    説明
        マイクロSDから、またはシリアルフラッシュロムから画像を呼び、任意の場所に表示する。

**********************************************************************/
void fnLCDCP(unsigned int type,unsigned int uiX,unsigned int uiY,unsigned int Xsize,unsigned int Ysize,unsigned int addrees){
    string1="P";

    tohex1(type);
    strcpy(string2,hexbuf);

    tohex3(uiX);
    strcat(string2,hexbuf);

    tohex3(uiY);
    strcat(string2,hexbuf);

    tohex3(Xsize);
    strcat(string2,hexbuf);

    tohex3(Ysize);
    strcat(string2,hexbuf);

    tohex8(addrees);
    strcat(string2,hexbuf);

    fnMake_sum_and_Trans();
}

/********************************************************************
    関数名
        fnLCDCZ
    説明
        ブザーを鳴らす。
    引数
        type:0 常時ON
        time: 鳴らす時間。
********************************************************************/

void fnLCDCZ(unsigned int type,unsigned int time){
    string1 = "Z";
    
    tohex3(time);
    strcpy(string2,hexbuf);
    
    fnMake_sum_and_Trans();
 
}

/*********************************************************************
    関数名
        fntget
    引数
        ptr：受信したtコマンドが収納されているアドレス
    戻り値
        なし
    説明
        t1コマンドによって送られてきた座標データを
        (LCDCuiX,LCDCuiY)へ代入する。

**********************************************************************/
void fntget(char *ptr)
{
    char LCDCdataX[4],LCDCdataY[4];
    ptr++;
    LCDCdataX[0] = *ptr;
    ptr++;
    LCDCdataX[1] = *ptr;
    ptr++;
    LCDCdataX[2] = *ptr;
    ptr++;
    LCDCdataX[3] = '\0';

    LCDCdataY[0] = *ptr;
    ptr++;
    LCDCdataY[1] = *ptr;
    ptr++;
    LCDCdataY[2] = *ptr;
    ptr++;
    LCDCdataY[3] = '\0';

    LCDCuiX = (htoi(LCDCdataX) / 2) -10;
    LCDCuiY = htoi(LCDCdataY) / 3.7;
}
/*********************************************************************
    関数名
        fnt
    引数
        ptr：受信したtコマンドが収納されているアドレス
    戻り値
        なし
    説明
        tコマンドの2文字目のタッチイベントを判断する。

**********************************************************************/
void fnt(char *ptr)
{
    ptr++;
    if(*ptr == '1') {
        //タッチパネルが押されているとき
        fntget(ptr);
    } else if(*ptr =='0') {
        //タッチパネルが離されているとき
//      fntget(ptr);
        LCDCuiX = 0;
        LCDCuiY = 0;
    } else {
    }
}
/***************************************
関数名：fnLCDC_RTSset
引数：type
      1:RTSを読取り
      0:RTSを無視
説明：RTS機能を読み取るかを決める。
***************************************/
void fnLCDC_RTSset(int type)
{
    if(type == 1) {
        RTS_flag = 1;
    } else {
        RTS_flag = 0;
    }
}
/***************************************
関数名：fnSerial_Decision_Return_only
引数：なし
説明：受信したコマンドを送信する。（USBを使っての確認用）
***************************************/
void fnSerial_Decision_Return_only(void){

    for(;;) {
        if(inCount3 == outCount3) break;
        if(inCount3 != outCount3) {
            cBuffer3[usBufCount3] = rBuffer3[outCount3];
            usBufCount3++;
            if(usBufCount3 >= 499) cBuffer3[0] = 0x0d;
            if(++outCount3>499) outCount3=0;
        }

        if((usBufCount3>=1) && (cBuffer3[usBufCount3-1] == CR)) break;     //CRだったらforを抜ける。
    }
    if((usBufCount3>=1) && (cBuffer3[usBufCount3-1] == CR)) {          //CRだったら

        usBufCount3 = 0;
        fnputus3(cBuffer3);
    }
}

/***************************************
関数名：fnSerial_Decision
引数：なし
説明：受信したコマンドを調べる。
***************************************/
void fnSerial_Decision(void)
{
    char *ptr;

    for(;;) {
        if(inCount3 == outCount3) break;
        if(inCount3 != outCount3) {
            cBuffer3[usBufCount3] = rBuffer3[outCount3];
            usBufCount3++;
            if(usBufCount3 >= 499) cBuffer3[0] = 0x0d;
            if(++outCount3>499) outCount3=0;
        }

        if((usBufCount3>=1) && (cBuffer3[usBufCount3-1] == CR)) break;     //CRだったらforを抜ける。
    }
    if((usBufCount3>=1) && (cBuffer3[usBufCount3-1] == CR)) {          //CRだったら

        usBufCount3 = 0;

        ptr = cBuffer3;
        switch(*ptr) {
            case 't':
                fnt(ptr);
                break;
            case 'a':

                break;
            case 'm':

                break;
            case 0x0d:
                break;

            default:
                break;
        }
        ptr++;

        switch(*ptr) {
            case 'K':
                command_returncheck_flag= 0;
            break;
            case 'E':
//                command_returncheck_flag= 0;
            break;
            default:
                break;
        }
    }
}
